<!DOCTYPE html>
<!--
* PHP4 :affichageVisite.php
-->
<html>
<head>
    <meta charset="UTF-8" />
    <title>Liste des comptes-rendus</title>
    <link rel="stylesheet" type="text/css" href="./css/affichageVisite.css" />
</head>
<body>
    <?php
    include_once("entete.php");
    include_once("modele/accesBDD.php");

    $order = isset($_GET['order']) ? $_GET['order'] : 'date';
    $sort = isset($_GET['sort']) ? $_GET['sort'] : 'asc';
    ?>
    <div id="titre"><h2>Liste des comptes-rendus</h2></div>
    <br>

<form method="post">
        <!--<div class="menuNav">
            <input class="boutonNav" type="submit" name="submit2" value="← Page précédente">  page précédente 
            <input class="boutonNav" type="submit" name="submit1" value="Page suivante →">   page suivante 
        </div> -->
        <br>
    <table>
        <thead>
            <tr>
                <th>Praticien</th>
                <th><a href="?order=date&sort=<?php echo ($sort == 'asc') ? 'desc' : 'asc'; ?>" id='sort'>Date visite ↑↓</a></th>
                <th>Date C-R</th>
                <th>Dernière modif</th>
                <th>Remarque</th>
                <th>Motif de la visite</th>
                <th>Medicament 1</th>
                <th>Medicament 2</th>
                <th>Confiance</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
        

<?php
// Recherche des visites de l'utilisateur afin de les afficher

//------------LISTE DÉROULANTE----------------//
$dbh = connexion();
$page = 0;
$numNavMin = 0;
$numNavMax = 10;
$nbVisites = nombreDeVisites($dbh,$_SESSION["id"]);
$statut=$_SESSION["statut"];
$nbInputs = ceil($nbVisites / 10);


echo "<form method='post'>
<div class='menuNavNum'>
<p>Numéro de page : </p>";

$selected = 1;
if (isset($_POST["input"])) {
 $selected = $_POST["input"];
}

echo "<select name='input' onchange='this.form.submit()'>";
for ($i = 1; $i <= $nbInputs; $i++) {
 if ($i == $selected) {
    $page+=($i-1)*10;
 echo "<option value='$i' selected>$i</option>";
 } else {
 echo "<option value='$i'>$i</option>";
 }
}
echo "</select>";

if (isset($_POST["input"])) {
 $i = $_POST["input"];
 // decrement the values of the variables
 $numNavMin = (($i * 10) - 10)+1;
 $numNavMax = ($i * 10);
 unset($_POST["input"]);
}



if($page<0)
{$page=0;}

echo "<p class='nbVisites'>[$numNavMin-$numNavMax]</p>
<div class='boutonDiv'>
	<p>
		<a href='nouvelleVisite.php'>Ajouter un compte-rendu</a>
	</p> 
</div>

	
	</div>
</form>";
//---------------------------------------------------------------//






//-------------------------Remplissage du tableau----------------//
            $lesVisites = rechercherLesVisitesDuCommercial($dbh, $id, $page,$sort);
            while ($uneVisite = $lesVisites->fetch()) {
                $idUtil= $uneVisite['uId'];
                $vNum = $uneVisite['vNum'];
                $praticien = $uneVisite['pNom'] . " " . $uneVisite['pPrenom'];
                $vDate = $uneVisite["vDate"];
                $CRdate = $uneVisite["CRDate"];
                $CRdateVMaj = $uneVisite["CRDateMaj"];
                $rapport = $uneVisite["vRapport"];
                $motif = $uneVisite["motif"];
                $medic1 = $uneVisite["vMedicament1"];
                $medic2 = $uneVisite["vMedicament2"];
                $confiance = $uneVisite["vCoefConfiance"];
                echo "<tr>
                        <td>$praticien</td>
                        <td>$vDate</td>
                        <td>$CRdate</td>
                        <td>$CRdateVMaj</td>
                        <td>$rapport</td>
                        <td>$motif</td>
                        <td>$medic1</td>
                        <td>$medic2</td>
                        <td>";
                        for ($i = 0; $i < $confiance; $i++) {
                            echo "★";
                            }
                        echo "</td>
                        <td class='modifSuppr'>
                            <a href='detailVisite.php?id=$idUtil&numVisite=$vNum' id='detail'>👁</a>
                            <a href='modifVisite.php?id=$idUtil&numVisite=$vNum' id='modifier'>🖉</a>
                        </td>
                       </tr>";
            }
//------------------------------------------------------------------//

            ?>
        </tbody>

    </table>
    
</form>





    <div id="nouvelleVisite-message">
            <?php
            if (isset ($_GET["msg"])) {
                $msg = $_GET["msg"];
                echo "<p>$msg</p>";
                unset($_GET["msg"]);
            }
            ?>
    </div>
    



</body>
</html>
